<div class="tab-pane fade  {{$route == 'web-config'?'show active':''}}" id="web-config" role="tabpanel"
    aria-labelledby="web-config-tab">
    <form id="form-web-config" action="{{route('admin.settings.config')}}" method="POST" role="form"
        enctype="multipart/form-data" autocomplete="off">
        @csrf
        <div class="row">
            <div class="col-lg-6">
                <div class="form-group">
                    <label>Google Analytics ID</label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fa fa-google"></i></span>
                        </div>
                        <input type="text" name="googleanalyticsid" class="form-control" placeholder="UA-45868728-1"
                            value="{{setting('googleanalyticsid')}}">
                    </div>
                </div>
                <div class="form-group">
                    <label for="">Publisher ID</label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fa fa-bullhorn"></i></span>
                        </div>
                        <input type="text" name="publisherid" class="form-control"
                            placeholder="ca-pub-969333888777222111" value="{{setting('publisherid')}}">
                    </div>
                </div>
                <div class="form-group">
                    <label for="">Disqus Short Name</label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fa fa-comments"></i></span>
                        </div>
                        <input type="text" name="disqusshortname" class="form-control"
                            placeholder="Your website shortname" value="{{setting('disqusshortname')}}">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label>Analytics View ID</label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fa fa-bar-chart"></i></span>
                        </div>
                        <input type="text" name="analytics_view_id" class="form-control" placeholder="223111254"
                            value="{{setting('analytics_view_id')}}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Credentials File</label><br>
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" accept=".json" name="credentials_file" class="custom-file-input"
                                id="credentialFile" value="{{setting('credentials_file')}}">
                            <label class="custom-file-label" for="credentialFile">Choose
                                File</label>
                        </div>
                    </div>
                    <p>
                        <small>
                            Browse service account credentials json file<br>
                        </small>
                    </p>
                </div>
                <div class="form-group">
                    <label>GOOGLE MAP CODE</label>
                    <textarea name="googlemapcode" class="form-control" rows="5"
                        placeholder="https://www.google.com/maps/embed/v1/place?q=place_id:ChIJZW3qh40Q_zkRz2Ey-U4DfWI&key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8">{{setting('googlemapcode')}}</textarea>

                    {{-- <iframe width="600" height="450" style="border:0" loading="lazy" allowfullscreen
                        src="https://www.google.com/maps/embed/v1/place?q=place_id:ChIJZW3qh40Q_zkRz2Ey-U4DfWI&key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8">
                    </iframe> --}}
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-lg-12">
                <button id="submit-web-config" type="submit" class="btn btn-info float-right">Save</button>
            </div>
        </div>
    </form>
    <hr>
    <div class="row mt-3">
        <div class="form-group">
            <label>Sitemap</label>
            <div>
                <a href="{{route('admin.settings.sitemap')}}" class="btn btn-info">
                    <i class="fa fa-file-code-o"></i> Generate Sitemap
                </a>
            </div>
            <p>
                <small>
                    See genereate results: <a href="{{asset('sitemap.xml')}}" target="blank">Sitemap</a><br>
                </small>
            </p>
        </div>
    </div>
    <hr>
    <div class="row mt-3">
        <div class="col-lg-12">
            <form action="{{route('admin.settings.maintain')}}" method="post">
                @csrf @method('put')
                <h1>App Maintenance Mode</h1>
                <input type="hidden" value="maintenance" name="type">
                <div class="col-md-12 text-center mt-5">
                    @if ($app->isDownForMaintenance())
                    <input type="hidden" name="value" value="1">
                    <button type="submit" class="btn btn-success btn-lg"><i class="fa fa-plug"></i> GO LIVE</button>
                    @else
                    <input type="hidden" name="value" value="0">
                    <input type="text" name="secret" value="ds-secret-{{now()->format('Y')}}" class="form-control"
                        placeholder="Enter secret" id="secret">
                    <button type="submit" class="btn btn-danger btn-lg"><i class="fa fa-power-off"></i> SHUT
                        DOWN</button>
                    @endif
                </div>
            </form>
        </div>
    </div>
</div>
